<?php

namespace Database\Seeders;

use App\Models\User;
use App\Policies\HasPermissionTrait;
use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Support\Str;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {


        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();



        // policy permissions
        $traitFunctions = array_merge(get_class_methods('Illuminate\Auth\Access\HandlesAuthorization'),
                    get_class_methods('App\Policies\HasPermissionTrait'));
        foreach ( new \DirectoryIterator(app_path('Policies')) as $fileinfo) {
            if (!$fileinfo->isDot() && $fileinfo->getBasename('.php') != 'BasePolicy' ) {
                $className = '\App\Policies\\'.$fileinfo->getBasename('.php');
                $reflectionClass = new \ReflectionClass($className);
                $methods = array_filter(
                    $reflectionClass->getMethods(),
                    function ($method) use ($className) {
//                        dd($method->getDeclaringClass()->getName(),$className);

                        return '\\'.$method->getDeclaringClass()->getName() === $className && $method->isPublic();
                    }
                );
                $policies = array_map(fn($m) => $m->getName(), $methods);
                $policies = array_diff($policies,$traitFunctions);

                foreach ($policies as $policy) {
//                    $tags = [];
//                    $annotate = $reflectionClass->getMethod($policy)->getDocComment();
//                    foreach (Str::of($annotate)->matchAll('/@\w+/') as $match)
//                        $tags[] = Str::remove('@',$match);

                    $name = $fileinfo->getBasename('Policy.php');
                    Permission::createOrFirst([
                        'group' => $name,
                        'title' => $name,
//                        'tag' => array_intersect($tags,['tenant','landlord']),
                        'name' => Str::kebab($name).'.'.Str::kebab($policy).'.*',
                        'guard_name' => 'web'
                    ]);
                }
            }
        }

        // Create policies Super-Admin Role and assign all Permissions
        $role = Role::createOrFirst(['name' => 'super-admin', 'guard_name' => 'web']);
        $role->givePermissionTo(Permission::all());



        // trans file generator
//        $trans = Permission::all()->mapWithKeys(function (Permission $item, int $key) {
//            return [$item['name'] => Str::replace(':', ' ', $item['name']) ];
//        })->toJson(JSON_PRETTY_PRINT);
//        unlink(base_path('lang/en.json'));
//        file_put_contents(base_path('lang/en.json'),$trans);

    }
}
