<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();
        $this->call(RolesAndPermissionsSeeder::class);

        $admin = User::create([
            'name'  => 'Mirvan',
            'email'=>   'me@mirvan.ir',
            'password'  => Hash::make('123123123'),
            'is_active' => true,
        ]);
        User::factory()->create([
            'name' => 'Mirvan2 User',
            'email' => 'me2@mirvan.ir',
            'password' => Hash::make('123123123')
        ]);
        $admin->assignRole('super-admin');
    }
}
