<?php

use App\Models\Material;
use App\Models\RecipeVersion;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('recipe_version_materials', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(RecipeVersion::class);
            $table->foreignIdFor(Material::class);
            $table->decimal('qty',14,4);
            $table->decimal('target_weight',14,4)->nullable();
            $table->decimal('zero_band',5,2)->nullable();
            $table->decimal('upper_threshold',5,2)->nullable();
            $table->decimal('lower_threshold',5,2)->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('recipe_version_materials');
    }
};
