<?php

use App\Models\Recipe;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('recipe_versions', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->smallInteger('code');
            $table->boolean('is_enabled')->default(true);
            $table->string('description')->nullable();
            $table->enum('type',data_get(\App\Enums\RecipeType::cases(), '*.value'));
            $table->foreignIdFor(Recipe::class);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('recipe_versions');
    }
};
