<?php

namespace App\Providers;

use App\Models\User;
use App\Nova\Dashboards\Example;
use App\Nova\PermissionResource;
use App\Nova\RoleResource;
use App\Policies\PermissionPolicy;
use App\Policies\RolePolicy;
use GeneaLabs\NovaHorizon\NovaHorizon;
use Illuminate\Support\Facades\Gate;
use Laravel\Fortify\Features;
use Laravel\Nova\Events\ServingNova;
use Laravel\Nova\Nova;
use Laravel\Nova\NovaApplicationServiceProvider;

class NovaServiceProvider extends NovaApplicationServiceProvider
{
    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        parent::boot();

        Nova::enableRTL();
        Nova::withBreadcrumbs();
        Nova::withoutNotificationCenter();
        Nova::userLocale(function () {
            return match (app()->getLocale()) {
                'en' => 'en-US',
                'fa' => 'fa-IR',
                default => 'fa',
            };
        });

//        Nova::mainMenu(function (Request $request) {
//            return [
//                MenuSection::dashboard(Main::class)->icon('chart-bar'),
//
//                MenuSection::make('Customers', [
//                    MenuItem::resource(UserResource::class),
//                ])->icon('user')->collapsable(),
//
//                MenuSection::make('Content', [
//                ])->icon('document-text')->collapsable(),
//            ];
//        });

        Nova::footer(function ($request) {
            return \Blade::render('
            <div class="mt-8 leading-normal text-xs text-gray-500 space-y-1">
            @env(\'local\')
                <p class="text-center">This is local!</p>
            @endenv
            @env(\'prod\')
                <p class="text-center">This is production!</p>
            @endenv
            </div>
        ');
        });
    }

    /**
     * Register the configurations for Laravel Fortify.
     */
    protected function fortify(): void
    {
        Nova::fortify()
            ->features([
                Features::updatePasswords(),
                // Features::emailVerification(),
                // Features::twoFactorAuthentication(['confirm' => true, 'confirmPassword' => true]),
            ])
            ->register();
    }

    /**
     * Register the Nova routes.
     */
    protected function routes(): void
    {
        Nova::routes()
            ->withAuthenticationRoutes(default: true)
            ->withPasswordResetRoutes()
            ->withoutEmailVerificationRoutes()
            ->register();
    }

    /**
     * Register the Nova gate.
     *
     * This gate determines who can access Nova in non-local environments.
     */
    protected function gate(): void
    {
        Gate::define('viewNova', function (User $user) {
            return true;
//            return in_array($user->email, [
//            ]);
        });
    }

    /**
     * Get the dashboards that should be listed in the Nova sidebar.
     *
     * @return array<int, \Laravel\Nova\Dashboard>
     */
    protected function dashboards(): array
    {
        return [
            new \App\Nova\Dashboards\Main,

        ];
    }

    /**
     * Get the tools that should be listed in the Nova sidebar.
     *
     * @return array<int, \Laravel\Nova\Tool>
     */
    public function tools(): array
    {
        return [
            (new \Sereny\NovaPermissions\NovaPermissions())
                ->permissionResource(PermissionResource::class)
                ->roleResource(RoleResource::class)
                ->rolePolicy(RolePolicy::class)
                ->permissionPolicy(PermissionPolicy::class),
//                ->canSee(function ($request) {
//                    return $request->user()->hasPermissionTo('role.view-any',target_id: '*');
//                }),
//            new \Stepanenko3\NovaHealth\NovaHealth,
//            new \DiegoDrese\NovaBackupManager\NovaBackupManager,
            new NovaHorizon(),
        ];
    }

    /**
     * Register any application services.
     */
    public function register(): void
    {

        parent::register();
        Nova::serving(function (ServingNova $event) {
            Nova::style('vazirmatn', \Vite::asset('resources/css/vazirmatn.css'));
        });

    }
}
