<?php

namespace App\Policies;
//use Illuminate\Database\Eloquent\Model as User;
//use Sereny\NovaPermissions\Policies\BasePolicy;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

/**
 * @PolicyClass
 * @Group(permission)
 * @Columns(id ,name , group,guard_name , available_configs)
 * @DefaultColumns(id ,name , group,guard_name)
 * @HiddenColumns(available_configs)
 * @Cards()
 * @Lenses()
 * @Filters()
 * @Actions()
 */
class PermissionPolicy extends BasePolicy
{
    use HandlesAuthorization;


    public $key = 'permission';


    /**
     * @DefaultColumns()
     * @Columns()
     * @HiddenColumns()
     * @Queries(limitedQuery , isActive , hasVerifiedEmail)
     * @Cards()
     * @Lenses()
     * @Filters()
     * @Actions()
     */
    public function viewAny(User $user): bool
    {
        return parent::viewAny($user);
    }


    /**
     * @DefaultColumns()
     * @Columns()
     * @HiddenColumns()
     * @Queries(limitedQuery , isActive , hasVerifiedEmail)
     * @Cards()
     * @Lenses()
     * @Filters()
     * @Actions()
     */
    public function view(User $user, $model): bool
    {
        return parent::view($user, $model);
    }

    /**
     * @DefaultColumns()
     * @Columns()
     * @HiddenColumns()
     * @Cards()
     */
    public function create(User $user): bool
    {
        return parent::create($user);
    }

    /**
     * @DefaultColumns(id , group, guard_name )
     * @Columns(id , group, guard_name , available_configs)
     * @HiddenColumns(name , available_configs)
     * @Cards()
     */

    public function update(User $user, $model): bool
    {
        return parent::update($user, $model);
    }

    public function delete(User $user, $model): bool
    {
        return parent::delete($user, $model);
    }

    public function restore(User $user, $model): bool
    {
        return parent::restore($user, $model);
    }

    public function forceDelete(User $user, $model): bool
    {
        return parent::forceDelete($user, $model);
    }
}
