<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Database\Eloquent\Model;

class BasePolicy {

    use HandlesAuthorization;

    /**
     * @var string
     */
    protected $key;

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User $user
     * @return mixed
     */
    public function create(User $user)
    {
        return $this->hasPermissionTo($user, 'create');
    }

    /**
     * Determine whether the user can delete the User.
     *
     * @param  \Illuminate\Database\Eloquent\Model $user
     * @param  \Illuminate\Database\Eloquent\Model $model
     * @return mixed
     */
    public function delete(User $user, $model)
    {
        debug([ 'delete' =>$this->hasPermissionTo($user, 'delete','1')] );

        return $this->hasPermissionTo($user, 'delete') || $this->hasPermissionTo($user, 'delete',$model->id);
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \Illuminate\Database\Eloquent\Model $user
     * @param  \Illuminate\Database\Eloquent\Model $model
     * @return mixed
     */
    public function forceDelete(User $user, $model)
    {
        return $this->hasPermissionTo($user, 'forceDelete') || $this->hasPermissionTo($user, 'forceDelete' , $model->id);
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \Illuminate\Database\Eloquent\Model $user
     * @param  \Illuminate\Database\Eloquent\Model $model
     * @return mixed
     */
    public function restore(User $user, $model)
    {
        return $this->hasPermissionTo($user, 'restore') || $this->hasPermissionTo($user, 'restore' , $model->id);
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \Illuminate\Database\Eloquent\Model $user
     * @param  \Illuminate\Database\Eloquent\Model $model
     * @return mixed
     */
    public function update(User $user, $model)
    {
//        debug($this->buildPermission('update'),$this->hasPermissionTo($user, 'update'), $this->hasPermissionTo($user, 'update.'.$model->id));
        return $this->hasPermissionTo($user, 'update')|| $this->hasPermissionTo($user, 'update',$model->id);
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \Illuminate\Database\Eloquent\Model $user
     * @param  \Illuminate\Database\Eloquent\Model $model
     * @return mixed
     */
    public function view(User $user, $model)
    {
        return $this->hasPermissionTo($user, 'view') || $this->hasPermissionTo($user, 'view' , $model->id);
    }

    /**
     * Determine whether the user can view any model.
     *
     * @param  \Illuminate\Database\Eloquent\Model $user
     */
    public function viewAny(User $user)
    {
        return $this->hasPermissionTo($user, 'viewAny') ;
    }

    /**
     * Build permission name
     *
     * @param string $name
     * @return string
     */
    protected function buildPermission(string $name, string $id = '*')
    {

        return \Str::kebab($this->key).".".\Str::kebab($name).".$id";
    }

    /**
     * Checks if user has permission
     *
     * @param \Illuminate\Database\Eloquent\Model $user
     * @return bool
     */
    protected function hasPermissionTo($user, $permission, $id = '*')
    {
        return (method_exists($user, 'isSuperAdmin') && $user->isSuperAdmin())
            || $user->hasPermissionTo($this->buildPermission($permission,$id));
    }
}
