<?php

namespace App\Nova;

use App\Models\RecipeVersionMaterial;
use Illuminate\Http\Request;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\Number;

class RecipeVersionMaterialResource extends Resource
{
    public static $model = RecipeVersionMaterial::class;

    public static $title = 'id';

    public static $search = [
        'id'
    ];
    public static $group = "Recipe";

    public function fields(Request $request): array
    {
        return [
            ID::make()->sortable(),

            Number::make('Qty')
                ->sortable()
                ->rules('required', 'decimal:0,4'),

            Number::make('Target Weight')
                ->sortable()
                ->rules('nullable', 'decimal:4'),

            Number::make('Zero Band')
                ->sortable()
                ->rules('nullable', 'decimal:2'),

            Number::make('Upper Threshold')
                ->sortable()
                ->rules('nullable', 'decimal:2'),

            Number::make('Lower Threshold')
                ->sortable()
                ->rules('nullable', 'decimal:2'),

            BelongsTo::make('RecipeVersion', 'recipeVersion', RecipeVersionResource::class)->peekable(),

            BelongsTo::make('Material', 'material', MaterialResource::class),
        ];
    }

    public function cards(Request $request): array
    {
        return [];
    }

    public function filters(Request $request): array
    {
        return [];
    }

    public function lenses(Request $request): array
    {
        return [];
    }

    public function actions(Request $request): array
    {
        return [];
    }
}
