<?php

namespace App\Models;

use App\Enums\CategoryType;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Kalnoy\Nestedset\NodeTrait;

class Category extends Model
{
    use NodeTrait;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = [];
//    protected $fillable = [
//        'name',
//        'description',
//        'type',
//        'parent_id',
//        'parent'
//
//    ];


    public function parentt(): BelongsTo
    {
        return $this->parent()->withou;
    }

    public function materials(): HasMany
    {
        return $this->hasMany(Material::class, 'category_id')->where('type',CategoryType::MATERIAL->name);
    }
    public function recipes(): HasMany
    {
        return $this->hasMany(Recipe::class, 'category_id')->where('type',CategoryType::RECIPE->name);
    }

}
